/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rescrcon;

import com.ibm.hwmca.base.rescrcon.RestoreCriticalConsoleDataResourceBundle;
import com.ibm.hwmca.base.rescrcon.RestoreCriticalDataBean;
import com.ibm.hwmca.base.rescrcon.RestoreCriticalDataConstants;
import com.ibm.hwmca.base.rescrcon.RestoreErrorIds;
import com.ibm.hwmca.base.rescrcon.RestoreException;
import com.ibm.hwmca.base.rescrcon.RestoreImpl;
import com.ibm.hwmca.base.rescrcon.RestoreParameterKeys;
import com.ibm.hwmca.base.rescrcon.RestoreParameters;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.system.StartupHook;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressEndEvent;
import com.ibm.hwmca.fw.task.ProgressReportListenerImpl;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletProgressListener;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;

public class RestoreTasklet
extends StartupHook
implements RestoreErrorIds,
RestoreParameterKeys,
RestoreCriticalDataConstants {
    private static final String TRACE_MASKT = "XRCCTKLT";
    private static final String TRACE_MASKF = "XRCCTKLF";
    private static final String TRACE_MASKD = "XRCCTKLD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.rescrcon.res.RestoreCriticalData";
    private static final String PANEL_NAME = "RestoreCriticalDataPanel";
    private boolean progressDismissed = false;
    private boolean restore_error = false;
    private UserContext usercontext = null;
    private LocalizableText taskname;
    RestoreImpl restoreImpl = null;
    RestoreParameters restoreParameters = null;
    RestoreCriticalDataBean databean = null;
    private int NumberOfFiles = 0;
    private String filePath = null;
    private String[] files = null;
    private String[] zipfiles = null;
    private String Table_Selection;

    public RestoreTasklet(PanelTasklet theTasklet) {
        super(theTasklet);
        Trace.trace(TRACE_MASKT, "-> RestoreTasklet.RestoreTasklet()");
        this.restoreParameters = RestoreParameters.getRestoreParameters();
        this.restoreImpl = new RestoreImpl();
        RestoreCriticalDataBean responseBean = new RestoreCriticalDataBean();
        responseBean.load();
        Trace.trace(TRACE_MASKT, "<- RestoreTasklet.RestoreTasklet()");
    }

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        File dsth1;
        String actbrst;
        block30: {
            Trace.trace(TRACE_MASKT, "-> RestoreTasklet.service()");
            actbrst = this.restoreParameters.getParm("restore.data.dir") + "/" + this.restoreParameters.getParm("restore.actbrst");
            File dst = new File(actbrst);
            if (!dst.exists()) {
                System.out.println("This is running on an SE");
                try {
                    if (!this.restoreImpl.isRestoreNeeded()) {
                        Trace.trace(TRACE_MASKF, "restore not needed- do nothing");
                        this.finished(1);
                        break block30;
                    }
                    if (taskletRequest.isInitialRequest()) {
                        Trace.trace(TRACE_MASKF, "initial request");
                        this.restoreImpl.loadRestoreMedia();
                        RestoreCriticalDataBean databean = new RestoreCriticalDataBean();
                        this.filePath = "/mnt/cdrom/";
                        File pathFile = null;
                        try {
                            pathFile = new File(this.filePath);
                        }
                        catch (NullPointerException e) {
                            Trace.trace(TRACE_MASKF, "-- Null Pointer Exeption" + this.filePath);
                        }
                        if (pathFile != null) {
                            Trace.trace(TRACE_MASKF, "pathFile is not null");
                            this.NumberOfFiles = 0;
                            this.files = pathFile.list();
                            if (this.files != null) {
                                Trace.trace(TRACE_MASKF, "Files found.");
                                Trace.trace(TRACE_MASKF, "Length of list is " + this.files.length);
                                Trace.trace(TRACE_MASKF, "Looking for just bzip files.");
                                for (int i = 0; i < this.files.length; ++i) {
                                    if (!this.files[i].endsWith(".tar.bz2")) continue;
                                    ++this.NumberOfFiles;
                                    Trace.trace(TRACE_MASKF, "i is " + i);
                                    Trace.trace(TRACE_MASKF, "files[i] is " + this.files[i]);
                                    Trace.trace(TRACE_MASKF, "NumberOF files is " + this.NumberOfFiles);
                                }
                                int Index = 0;
                                this.zipfiles = new String[this.NumberOfFiles];
                                Trace.trace(TRACE_MASKF, "Creating list of bzip files.");
                                for (int i = 0; i < this.files.length; ++i) {
                                    if (!this.files[i].endsWith(".tar.bz2")) continue;
                                    this.zipfiles[Index] = this.files[i];
                                    Trace.trace(TRACE_MASKF, "i is " + i);
                                    Trace.trace(TRACE_MASKF, "files[i] is " + this.files[i]);
                                    Trace.trace(TRACE_MASKF, "index is " + Index);
                                    Trace.trace(TRACE_MASKF, "zipfiles[index] is " + this.zipfiles[Index]);
                                    ++Index;
                                }
                            } else {
                                Trace.trace(TRACE_MASKF, "No list of files found.");
                                this.NumberOfFiles = 0;
                            }
                            if (this.NumberOfFiles != 0) {
                                Trace.trace(TRACE_MASKF, "-- NumberOfFiles is not 0 NOF is " + this.NumberOfFiles);
                                databean.setSelectedCpcChoiceList(this.zipfiles);
                            }
                        }
                        databean.setBeanName("RestoreCriticalDataBean");
                        taskletResponse.openModalChild(AUIML_FILE_NAME, PANEL_NAME, databean);
                        break block30;
                    }
                    if (taskletRequest.getData("event").equals("OkButton")) {
                        this.Table_Selection = (String)taskletRequest.getData("tableselection");
                        Trace.trace(TRACE_MASKT, "which bz2 ??: " + this.Table_Selection);
                        Trace.trace(TRACE_MASKT, "event is : " + taskletRequest.getData("event"));
                        boolean done = false;
                        while (!done) {
                            Trace.trace(TRACE_MASKF, "<- RestoreTasklet.isNOTInitialRequest()");
                            done = true;
                            Trace.trace(TRACE_MASKF, "completed restore preparation now popProg");
                            this.popProgressWindow();
                            Trace.trace(TRACE_MASKF, "done with restore, now reboot...");
                            if (this.restore_error) {
                                this.finished(1);
                                Object[] restoreErrorMsg = new String[1];
                                MessageText[] bmt = new BaseMessageText[1];
                                if (this.restoreImpl.getState() > 8) {
                                    bmt[0] = new BaseMessageText("RES00006", restoreErrorMsg);
                                } else {
                                    restoreErrorMsg[0] = new LocalizableText("com/ibm/hwmca/base/rescrcon/res/restoreres", RestoreCriticalConsoleDataResourceBundle.RestoreErrors(this.restoreImpl.getState())).toString();
                                    bmt[0] = new BaseMessageText("RES00005", restoreErrorMsg);
                                }
                                BaseMessageText title = new BaseMessageText("RES00008");
                                LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON, CommonMsgInterface.CANCEL_BUTTON};
                                LocalizableText userResponse = this.tasklet.showMessageBox(true, title, bmt, "ACT0201E", MsgType.ERROR_MESSAGE, options);
                                if (!userResponse.equals(CommonMsgInterface.CANCEL_BUTTON)) continue;
                                done = true;
                                this.finished(3);
                                continue;
                            }
                            this.restoreImpl.ejectRestoreMedia();
                            this.finished(3);
                        }
                    }
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception during init: " + e);
                    HException hexc = new HException(e);
                    new FrameworkLog(RestoreErrorIds._logInfo, 514, hexc).log();
                }
            }
        }
        if ((dsth1 = new File(actbrst)).exists()) {
            System.out.println("This is running on an HMC");
            try {
                if (taskletRequest.isInitialRequest()) {
                    Trace.trace(TRACE_MASKF, "initial request");
                }
                if (!this.restoreImpl.isRestoreNeeded()) {
                    this.finished(1);
                } else {
                    boolean done = false;
                    while (!done) {
                        try {
                            this.restoreImpl.restorePreparation();
                            done = true;
                            Trace.trace(TRACE_MASKF, "completed restore preparation");
                            this.popProgressWindow();
                            Trace.trace(TRACE_MASKF, "done with restore, now reboot...");
                            if (this.restore_error) {
                                this.finished(1);
                                continue;
                            }
                            this.finished(3);
                        }
                        catch (RestoreException rexc) {
                            Trace.trace(TRACE_MASKF, "caught exception: " + rexc.getMessage());
                            Object[] restoreErrorMsg = new String[1];
                            MessageText[] bmt = new BaseMessageText[1];
                            if (this.restoreImpl.getState() > 8) {
                                restoreErrorMsg[0] = rexc.getMessage();
                                bmt[0] = new BaseMessageText("RES00006", restoreErrorMsg);
                            } else {
                                restoreErrorMsg[0] = new LocalizableText("com/ibm/hwmca/base/rescrcon/res/restoreres", RestoreCriticalConsoleDataResourceBundle.RestoreErrors(this.restoreImpl.getState())).toString();
                                bmt[0] = new BaseMessageText("RES00005", restoreErrorMsg);
                            }
                            BaseMessageText title = new BaseMessageText("RES00008");
                            LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON, CommonMsgInterface.CANCEL_BUTTON};
                            LocalizableText userResponse = this.tasklet.showMessageBox(true, title, bmt, "ACT0201E", MsgType.ERROR_MESSAGE, options);
                            if (!userResponse.equals(CommonMsgInterface.CANCEL_BUTTON)) continue;
                            done = true;
                            this.finished(3);
                        }
                    }
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception during init: " + e);
                HException hexc = new HException(e);
                new FrameworkLog(RestoreErrorIds._logInfo, 514, hexc).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<- RestoreTasklet.service()");
    }

    private void notifyThisTasklet() {
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void popProgressWindow() {
        Trace.trace(TRACE_MASKT, "-> RestoreTasklet.run()");
        long duration = new Long(this.restoreParameters.getParm("restore.duration"));
        LocalizableText initialText = new LocalizableText("In progress...");
        String id = "1";
        this.taskname = new LocalizableText("Restore Console Data");
        ObjectId[] thisId = new ObjectId[1];
        Trace.trace(TRACE_MASKF, "cast the panel tasklet");
        PanelTasklet panelTasklet = this.tasklet;
        Trace.trace(TRACE_MASKF, "now create an object id for the panel tasklet");
        thisId[0] = new ObjectId(panelTasklet);
        ProgressData[] progData = new ProgressData[1];
        Trace.trace(TRACE_MASKF, "create a progress data array");
        progData[0] = new ProgressData(this.taskname, thisId[0], duration);
        Trace.trace(TRACE_MASKF, "create a progress listener");
        PanelTaskletProgressListener progListener = new PanelTaskletProgressListener(panelTasklet);
        try {
            Trace.trace(TRACE_MASKF, "create a progress start event");
            ProgressStartEvent start = new ProgressStartEvent(this.taskname, progData, duration, initialText, id);
            Trace.trace(TRACE_MASKF, "start the listener");
            progListener.startProgress(start);
            Trace.trace(TRACE_MASKF, "create a restore progress listener");
            ProgressReportListenerImpl restoreListener = new ProgressReportListenerImpl(id, thisId, progListener);
            Trace.trace(TRACE_MASKF, "waiting for the progress window to be dismissed");
            RestoreTasklet restoreTasklet = this;
            synchronized (restoreTasklet) {
                String actbrst = this.restoreParameters.getParm("restore.data.dir") + "/" + this.restoreParameters.getParm("restore.actbrst");
                File dsth2 = new File(actbrst);
                if (dsth2.exists()) {
                    System.out.println("This was compiled on an HMC");
                    this.Table_Selection = "hmcbkp.tar.bz2";
                }
                Trace.trace(TRACE_MASKT, "which bz2, pop ??: " + this.Table_Selection);
                this.restoreImpl.restore(restoreListener, this.Table_Selection);
            }
            Trace.trace(TRACE_MASKF, "progress window has been dismissed, so now we can end");
        }
        catch (RestoreException rexc) {
            Trace.trace(TRACE_MASKF, "restore exception caught: " + rexc.getMessage());
            this.restore_error = true;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "exception caught in run: " + e.getMessage());
            progListener.endProgress(new ProgressEndEvent(id));
            RestoreException rexc = new RestoreException(e);
            new FrameworkLog(RestoreErrorIds._logInfo, 514, rexc).log();
        }
        Trace.trace(TRACE_MASKT, "<- RestoreTasklet.run()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> RestoreTasklet.logException()");
        Trace.trace(TRACE_MASKT, "processing exception: " + throwable);
        HException hexc = new HException(throwable);
        new FrameworkLog(RestoreErrorIds._logInfo, 512, hexc).log();
        Trace.trace(TRACE_MASKT, "<- RestoreTasklet.logException()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressEnded(String id) {
        Trace.trace(TRACE_MASKT, "-> RestoreTasklet.progressEnded()");
        RestoreTasklet restoreTasklet = this;
        synchronized (restoreTasklet) {
            this.progressDismissed = true;
            this.notify();
        }
        Trace.trace(TRACE_MASKT, "<- RestoreTasklet.progressEnded()");
    }
}

